from typing import Literal
import ext.aflow.scripts.optimized.HumanEval.workflows.template.operator as operator
import ext.aflow.scripts.optimized.HumanEval.workflows.round_11.prompt as prompt_custom
from provider.llm_provider_registry import create_llm_instance
from utils.cost_manager import CostManager

DatasetType = Literal["HumanEval", "MBPP", "GSM8K", "MATH", "HotpotQA", "DROP"]

class Workflow:
    def __init__(
        self,
        name: str,
        llm_config,
        dataset: DatasetType,
    ) -> None:
        self.name = name
        self.dataset = dataset
        self.llm = create_llm_instance(llm_config)
        self.llm.cost_manager = CostManager()
        self.custom = operator.Custom(self.llm)
        self.custom_code_generate = operator.CustomCodeGenerate(self.llm)
        self.test = operator.Test(self.llm)

    async def __call__(self, problem: str, entry_point: str):
        analysis = await self.custom(input=problem, instruction=prompt_custom.ANALYZE_PROBLEM_PROMPT)
        solution = await self.custom_code_generate(problem=problem, entry_point=entry_point, instruction=prompt_custom.CODE_GENERATE_PROMPT + f"\n\nProblem analysis:\n{analysis['response']}")
        test_result = await self.test(problem=problem, solution=solution['response'], entry_point=entry_point)
        
        if test_result['result']:
            return test_result['solution'], self.llm.cost_manager.total_cost
        else:
            improved_solution = await self.custom(input=f"Problem: {problem}\nFailed solution: {solution['response']}\nError: {test_result['solution']}\nProblem analysis: {analysis['response']}", instruction=prompt_custom.IMPROVE_SOLUTION_PROMPT)
            return improved_solution['response'], self.llm.cost_manager.total_cost
